DESCRIPTION.wincodec = Crystal Space VFW codec

#------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

PLUGINHELP += \
  $(NEWLINE)echo $"  make wincodec     Make the $(DESCRIPTION.wincodec)$"

endif # ifeq ($(MAKESECTION),rootdefines)
#------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: wincodec wincodecclean
plugins all: wincodec

wincodec:
	$(MAKE_TARGET) MAKE_DLL=yes
wincodecclean:
	$(MAKE_CLEAN)

endif # ifeq ($(MAKESECTION),roottargets)
#------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp plugins/video/format/codecs/wincodec

LIB.EXTERNAL.WINCODEC = -lvfw32
ifeq ($(USE_PLUGINS),yes)
  WINCODEC = $(OUTDLL)/wincodec$(DLL)
  LIB.WINCODEC = $(foreach d,$(DEP.WINCODEC),$($d.LIB))
  TO_INSTALL.DYNAMIC_LIBS += $(WINCODEC)
else
  WINCODEC = $(OUT)/$(LIB_PREFIX)wincodec$(LIB)
  DEP.EXE += $(wincodec)
  SCF.STATIC += wincodec
  TO_INSTALL.STATIC_LIBS += $(wincodec)
endif

INC.WINCODEC = $(wildcard plugins/video/format/codecs/wincodec/*.h)
SRC.WINCODEC = $(wildcard plugins/video/format/codecs/wincodec/*.cpp)
OBJ.WINCODEC = $(addprefix $(OUT)/,$(notdir $(SRC.WINCODEC:.cpp=$O)))
DEP.WINCODEC = CSUTIL CSSYS
CFG.WINCODEC =

TO_INSTALL.CONFIG += $(CFG.WINCODEC)
TO_INSTALL.DATA +=

MSVC.DSP += WINCODEC
DSP.WINCODEC.NAME = wincodec
DSP.WINCODEC.TYPE = plugin
# DSP.ODIVX.LIBS = decore

endif # ifeq ($(MAKESECTION),postdefines)
#----------------------------------------------------------------- targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: wincodec wincodecclean
wincodec: $(OUTDIRS) $(WINCODEC)

$(WINCODEC): $(OBJ.WINCODEC) $(LIB.WINCODEC)
	$(DO.PLUGIN) $(LIB.EXTERNAL.WINCODEC)

clean: wincodecclean
wincodecclean:
	-$(RM) $(WINCODEC) $(OBJ.WINCODEC)

ifdef DO_DEPEND
dep: $(OUTOS)wincodec.dep
$(OUTOS)wincodec.dep: $(SRC.WINCODEC)
	$(DO.DEP)
else
-include $(OUTOS)wincodec.dep
endif

endif # ifeq ($(MAKESECTION),targets)
