/*
    Copyright (C) 2001 by Norman Krmer

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// #include <divx/decore.h>
#include "cssysdef.h"
#include "wincodec.h"
#include "cssys/sysfunc.h"

CS_IMPLEMENT_PLUGIN

SCF_IMPLEMENT_IBASE (csWinCodec)
  SCF_IMPLEMENTS_INTERFACE (iAVICodec)
  SCF_IMPLEMENTS_INTERFACE (iBase)
SCF_IMPLEMENT_IBASE_END

SCF_IMPLEMENT_FACTORY (csWinCodec)
SCF_EXPORT_CLASS_TABLE (wincodec)
  SCF_EXPORT_CLASS (csWinCodec, "crystalspace.video.codec.avi.dvx1", "CrystalSpace WinCodec codec")
  SCF_EXPORT_CLASS (csWinCodec, "crystalspace.video.codec.avi.divx", "CrystalSpace WinCodec codec")
  SCF_EXPORT_CLASS (csWinCodec, "crystalspace.video.codec.avi.div4", "CrystalSpace WinCodec codec")
  SCF_EXPORT_CLASS (csWinCodec, "crystalspace.video.codec.avi.mp43", "CrystalSpace WinCodec codec")
  SCF_EXPORT_CLASS (csWinCodec, "crystalspace.video.codec.avi.mp42", "CrystalSpace WinCodec codec")
  SCF_EXPORT_CLASS (csWinCodec, "crystalspace.video.codec.avi.div3", "CrystalSpace WinCodec codec")
SCF_EXPORT_CLASS_TABLE_END

csWinCodec::csWinCodec (iBase *pParent)
{
  SCF_CONSTRUCT_IBASE (pParent);
  hic=NULL;
  ZeroMemory(&bin,sizeof(bin));
  ZeroMemory(&bout,sizeof(bout));
  bout.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
  rgbData=NULL;
}

csWinCodec::~csWinCodec ()
{
  if (bOK)
    // stop current processing
    ICClose(hic);
  if (rgbData)
    delete [] rgbData;
}

int min(int x,int y){
  if (x > y) return x;
  return y;
}
bool csWinCodec::Initialize (csStreamDescription *desc, uint8 *, uint32, uint8 *pFormatEx, uint32 nFormatEx)
{
  csVideoStreamDescription *vd = (csVideoStreamDescription *)desc;
  BITMAPINFO * binfo;
  binfo =(BITMAPINFO *)pFormatEx;
  FOURCC fcccodec;
 
  memcpy(&bin,binfo,min(sizeof(BITMAPINFOHEADER),(*binfo).bmiHeader.biSize));
  w = vd->width;
  h = vd->height;
  bOK = false;
  bout.bmiHeader.biWidth=w;
  bout.bmiHeader.biHeight=h;  // -h 
  bout.bmiHeader.biCompression=BI_RGB;
  bout.bmiHeader.biBitCount=32;
  bout.bmiHeader.biPlanes=1;
  bout.bmiHeader.biSizeImage=abs(w*h*4);
  
  memcpy(&fcccodec,&(*desc).codec,4);
  
  bin.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
  
 
  hic=ICDecompressOpen(ICTYPE_VIDEO,fcccodec, 
		       &(binfo->bmiHeader),NULL);  // NULL means any output.
                       // (LPBITMAPINFOHEADER) &bout.bmiHeader); 
  
  if (hic !=0){
    if (ICDecompressQuery(hic,&bin,&bout) !=ICERR_OK){
     csPrintf("RGBA32 output format not supported!!");
    }  
    
  if (ICDecompressBegin(hic, &bin.bmiHeader,&bout.bmiHeader) == ICERR_OK)
  {
  }
  else {
    csPrintf("DecBegin FAILED\n");
  }
  
  }
  if (hic == NULL){
    csPrintf("ERROR: NO CODEC AVAILABLE\n");
    csPrintf("Compression %s \n",vd->codec);
  }
  bOK= (hic != NULL);  // No Decompressor found...
  rgbData = new char[4*w*h];
  return bOK;
}

void csWinCodec::GetCodecDescription (csCodecDescription &desc)
{
  desc.bEncode = false; // not implemented yet
  desc.bDecode = true;
  desc.decodeoutput = CS_CODECFORMAT_RGBA_INTERLEAVED;
  desc.encodeinput = CS_CODECFORMAT_RGBA_INTERLEAVED;
}

bool csWinCodec::Decode (char *indata, uint32 inlength, void *&outdata)
{
  if (bOK)
    { bin.bmiHeader.biSizeImage=inlength; //  ?!
    ICDecompress(hic,ICDECOMPRESS_NOTKEYFRAME,&bin.bmiHeader,(LPVOID)indata, &bout.bmiHeader,rgbData);
    outdata=(void *)rgbData;
    return true;
  }
  return false;
}

bool csWinCodec::Encode (void *indata, char *outdata, uint32 &outlength)
{
  (void)indata;
  (void)outdata;
  (void)outlength;
  return false;
}
