/* 
    Copyright (C) 2003 by TURBO J
  
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
  
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
  
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cssysdef.h"
#include "csver.h"
#include "csjoywin.h"
#include "ivaria/reporter.h"
#include "csutil/csstring.h"

// using DirectInput -- included in csjoywin.h

// no config yet
// #define CS_WINDOWS_JOYSTICK_CFG "/config/joystwin.cfg"
// #define CS_WINDOWS_JOYSTICK_KEY "Device.JoyWin."

// #define CS_LINUX_JOYSTICK_OLD_EVENTS // the values of the first two axis are sent only

CS_IMPLEMENT_PLUGIN;

SCF_IMPLEMENT_IBASE (csWindowsJoystick)
  SCF_IMPLEMENTS_INTERFACE (iComponent)
  SCF_IMPLEMENTS_EMBEDDED_INTERFACE (iEventPlug)
  SCF_IMPLEMENTS_EMBEDDED_INTERFACE (iEventHandler)
SCF_IMPLEMENT_IBASE_END

SCF_IMPLEMENT_EMBEDDED_IBASE (csWindowsJoystick::eiEventPlug)
  SCF_IMPLEMENTS_INTERFACE (iEventPlug)
SCF_IMPLEMENT_EMBEDDED_IBASE_END

SCF_IMPLEMENT_EMBEDDED_IBASE (csWindowsJoystick::eiEventHandler)
  SCF_IMPLEMENTS_INTERFACE (iEventHandler)
SCF_IMPLEMENT_EMBEDDED_IBASE_END

csWindowsJoystick::csWindowsJoystick (iBase *parent):
  object_reg(NULL),
  joystick(NULL),
  nJoy(0),
  eq(NULL),
  EventOutlet(NULL)
{
  SCF_CONSTRUCT_IBASE(parent);
  SCF_CONSTRUCT_EMBEDDED_IBASE(scfiEventPlug);
  SCF_CONSTRUCT_EMBEDDED_IBASE(scfiEventHandler);
}

csWindowsJoystick::~csWindowsJoystick ()
{
  Close ();
}

bool csWindowsJoystick::Initialize (iObjectRegistry *oreg)
{
  object_reg = oreg;
  joystick=NULL;
  return Init ();
}

bool csWindowsJoystick::HandleEvent (iEvent &)

{
  HRESULT hr;
  int nstate,last_state;
  for (int i=0; i < nJoy; i++){
    joystick[i].device->Poll();
    nstate=joystick[i].nstate;
    hr=joystick[i].device->GetDeviceState((DWORD)sizeof(DIJOYSTATE2), (LPVOID)&joystick[i].state[nstate]);
    if (FAILED (hr)){
      joystick[i].device->Acquire();  // try to reacquire
    } else {
      last_state=1-nstate;
      for (int btn=0; btn<128;btn++) {
        if (joystick[i].state[nstate].rgbButtons[btn]!=joystick[i].state[last_state].rgbButtons[btn]) {
          EventOutlet->Joystick(i,btn+1,joystick[i].state[nstate].rgbButtons[btn]!=0,
            joystick[i].state[nstate].lX,joystick[i].state[nstate].lY);
        }
      }    
      if ((joystick[i].state[nstate].lX != joystick[i].state[last_state].lX) ||
              (joystick[i].state[nstate].lY != joystick[i].state[last_state].lY) ){
                EventOutlet->Joystick(i, 0,0,joystick[i].state[nstate].lX,joystick[i].state[nstate].lY);
      }
      joystick[i].nstate=last_state;
    }
  }
  return false;
}

// DirectInputDeviceEnumerator Function

BOOL CALLBACK DIEnumDevicesCallback(
  LPCDIDEVICEINSTANCE lpddi,  
  LPVOID pvRef  )
{
  csWindowsJoystick * po;
  (LPVOID)po=pvRef;
  po->CreateDevice (lpddi);
  return DIENUM_CONTINUE;
}

bool csWindowsJoystick::CreateDevice (const DIDEVICEINSTANCE*  pdidInstanc)
{ DIDEVCAPS caps;
  DIPROPRANGE diprg;
  diprg.diph.dwSize= sizeof(diprg);
  diprg.diph.dwHeaderSize =sizeof(diprg.diph);
  // diprg.diph.dwObj=;
  diprg.diph.dwHow=DIPH_BYOFFSET;
  diprg.lMin = -32767;
  diprg.lMax = 32767;
  if (joystick ==NULL){
    if (pdidInstanc) nJoy++;
  } else { 
    if (nJoy < max_Joy) {
      lpdin->CreateDevice (pdidInstanc->guidInstance,(LPDIRECTINPUTDEVICE*)&joystick[nJoy].device, NULL);
      if (&joystick[nJoy].device) {
        joystick[nJoy].number=nJoy;
        caps.dwSize=sizeof(caps);
        joystick[nJoy].device->GetCapabilities (&caps);
        joystick[nJoy].nAxes=caps.dwAxes;
        joystick[nJoy].nButtons=caps.dwButtons;    
        joystick[nJoy].device ->SetDataFormat (&c_dfDIJoystick2);
        diprg.diph.dwObj= 0; // lX
        joystick[nJoy].device ->SetProperty(DIPROP_RANGE ,&diprg.diph);
        diprg.diph.dwObj= 1* sizeof(LONG); //lY
        joystick[nJoy].device ->SetProperty(DIPROP_RANGE ,&diprg.diph);
        nJoy++;
      }
    }
  }
  return true;
}

bool csWindowsJoystick::Init ()
{
  nJoy=0; 
  csRef<iWin32Assistant> win32=CS_QUERY_REGISTRY (object_reg,iWin32Assistant);
  DirectInputCreate (win32->GetInstance (),DIRECTINPUT_VERSION,&lpdin,NULL);
  HWND window= win32->GetApplicationWindow ();
  if (lpdin){
    // only enum attached Joysticks
    max_Joy=0;
    nJoy=0;
    // get Number of Devices
    lpdin->EnumDevices(DIDEVTYPE_JOYSTICK,&DIEnumDevicesCallback,(LPVOID)this,DIEDFL_ATTACHEDONLY);
    // Alloc Memory
    max_Joy=nJoy;
    joystick = new joydata[nJoy];
    nJoy=0;
    // Get Details of Devices
    lpdin->EnumDevices(DIDEVTYPE_JOYSTICK,&DIEnumDevicesCallback,(LPVOID)this,DIEDFL_ATTACHEDONLY);
    max_Joy=nJoy;            //?? Nochmal zugewiesen :-/
    int i;
    for (i=0; i< max_Joy; i++) {
      joystick[i].device->SetCooperativeLevel(window,DISCL_EXCLUSIVE | DISCL_FOREGROUND); // lt. DX-SDK 4 Joysticks
      joystick[i].device->Acquire();	// This is one of the crazy things in DInput: (Un)Acquire! Who has to be shot for this?
    }
 // hook into eventqueue
    eq = CS_QUERY_REGISTRY(object_reg, iEventQueue);
    if (eq)
    {
      eq->RegisterListener (&scfiEventHandler, CSMASK_Nothing);
      EventOutlet = eq->CreateEventOutlet (&scfiEventPlug);
    }
    Report (CS_REPORTER_SEVERITY_NOTIFY,
            "Joystick Plugin Loaded!!\n");
  } else
  {
    Report (CS_REPORTER_SEVERITY_NOTIFY,
            "No operable joystick found/Direct Input ERROR\n");
  }

  return eq && EventOutlet;
}


bool csWindowsJoystick::Close ()
{
  if (eq)
  {
    eq->RemoveListener (&scfiEventHandler);
    eq = NULL;
  }
  EventOutlet = NULL;
  for (int i=0; i<nJoy; i++)
    {  
      joystick[i].device->Unacquire ();
      joystick[i].device->Release ();
    }
  delete [] joystick;
  joystick = NULL;
  nJoy = 0;
  max_Joy=0;
  lpdin->Release();
  lpdin=NULL;
  return true;
}

void csWindowsJoystick::Report (int severity, const char* msg, ...)
{
  va_list arg;
  va_start (arg, msg);
  csRef<iReporter> rep = CS_QUERY_REGISTRY (object_reg, iReporter);
  if (rep)
  {
    rep->ReportV (severity, "crystalspace.device.joystick.windows", msg, arg);
  
  }
  else
  {
    csPrintfV (msg, arg);
    csPrintf ("\n");
  }
  va_end (arg);
}

SCF_IMPLEMENT_FACTORY (csWindowsJoystick);

/* -- Old SCF stuff here .. 
SCF_EXPORT_CLASS_TABLE (csjoywin)
  SCF_EXPORT_CLASS (csWindowsJoystick, "crystalspace.device.joystick.windows", 
                    "Crystal Space Joystick plugin for Windows")
SCF_EXPORT_CLASS_TABLE_END
*/
